CREATE TABLE DataProvider (
  DataProviderID varchar(25),
  DataProviderName varchar(100),
  DataProviderDescription varchar(255)
) ; 

CREATE INDEX IX1_DataProvider ON DataProvider (DataProviderID) ;

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('SQLSERVER','System.Data.SqlClient','SQL Server') ;

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('OLEDB','System.Data.OleDb','OLE DB') ;

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('ODBC','Microsoft.Data.Odbc','ODBC.NET') ;

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('DBPROVIDER','dbProvider','dbProvider for MySQL') ;

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('MYSQLDIRECT','CoreLab.MySql','MySQLDirect.NET') ;

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('ODPNET','Oracle.DataAccess','Oracle Data Provider') ;

INSERT INTO DataProvider (DataProviderID,DataProviderName,DataProviderDescription)
VALUES ('DB2NET','IBM.Data.DB2','DB2.NET Provider') ;


CREATE TABLE DataSource (
  DataSourceID varchar(38),
  DataSourceName varchar(100),
  DataProviderID varchar(25),
  TableViewName varchar(255),
  ConnectionString varchar(255),
  LastRefreshedDate timestamp,
  IsOnline char(1)
) ; 

CREATE INDEX IX1_DataSource ON DataSource (DataSourceID) ;


CREATE TABLE DataSourceColumns (
  DataSourceID varchar(38),
  ColumnName varchar(50),
  Description varchar(50),
  DataType char(1),
  IsCurrency char(1),
  Decimals int,
  Width int,
  Heading varchar(50),
  HasLookupList char(1),
  ExampleValue1 varchar(50),
  ExampleValue2 varchar(50)
) ; 

CREATE INDEX IX1_DSC ON DataSourceColumns (DataSourceID,ColumnName) ;


CREATE TABLE Filter (
  FilterID varchar(38),
  UserID varchar(50),
  DataSourceID varchar(38),
  FilterName varchar(50),
  FilterType char(1),
  LastSavedDate timestamp,
  WHEREClause varchar(4000),
  FilterDescription varchar(4000),
  FilterDescriptionTextOnly varchar(4000)
) ; 

CREATE INDEX IX1_Filter ON Filter (FilterID) ;
CREATE INDEX IX2_Filter ON Filter (UserID,DataSourceID) ;


CREATE TABLE FilterDetail (
  FilterID varchar(38),
  FilterNumber int,
  Conjunction varchar(3),
  ColumnName varchar(50),
  Operator varchar(50),
  Parameters varchar(4000)
) ; 

CREATE INDEX IX1_FilterDetail ON FilterDetail (FilterID,FilterNumber) ;


CREATE TABLE FilterOperators (
  Operator varchar(30),
  ParametersType varchar(10),
  SQL varchar(50),
  ListOrder int,
  OperatorName varchar(4)
) ; 

CREATE INDEX IX1_FilterOperators ON FilterOperators (Operator) ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Less Than','Single','< [1]',0,'lt') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Less Than or Equal To','Single','<= [1]',1,'lte') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Greater Than','Single','> [1]',2,'gt') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Greater Than or Equal To','Single','>= [1]',3,'gte') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Equals','Single','= [1]',4,'eq') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Does Not Equal','Single','<> [1]',5,'neq') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Begins With','Single','LIKE ''[1]%''',6,'bw') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Does Not Begin With','Single','NOT LIKE ''[1]%''',7,'nbw') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Contains','Single','LIKE ''%[1]%''',8,'co') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Does Not Contain','Single','NOT LIKE ''%[1]%''',9,'nco') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Ends With','Single','LIKE ''%[1]''',10,'ew') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Does Not End With','Single','NOT LIKE ''%[1]''',11,'new') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Between','Double','BETWEEN [1] AND [2]',12,'btw') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Not Between','Double','NOT BETWEEN [1] AND [2]',13,'nbtw') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is One Of','List','IN ([List])',14,'oo') ;

INSERT INTO FilterOperators (Operator,ParametersType,SQL,ListOrder,OperatorName)
VALUES ('Is Not One Of','List','NOT IN ([List])',15,'noo') ;


CREATE TABLE Report (
  ReportID varchar(38),
  UserID varchar(50),
  DataSourceID varchar(38),
  ReportName varchar(100),
  ReportTitle varchar(100),
  ReportSubTitle varchar(100),
  DetailSummaryFlag char(1),
  LastSavedDate timestamp,
  SELECTClause varchar(4000),
  GROUPBYClause varchar(4000),
  ORDERBYClause varchar(4000),
  DrillDownToID varchar(38)
) ; 

CREATE INDEX IX1_Report ON Report (ReportID) ;
CREATE INDEX IX2_Report ON Report (UserID,DataSourceID) ;
CREATE INDEX IX3_Report ON Report (DrillDownToID) ;


CREATE TABLE ReportDetail (
  ReportID varchar(38),
  ColumnNumber int,
  ColumnName varchar(50),
  OrderBy char(1),
  GroupBy char(1),
  Total char(1)
) ; 

CREATE INDEX IX1_ReportDetail ON ReportDetail (ReportID,ColumnNumber) ;


CREATE TABLE UserDataSource (
  UserID varchar(50),
  DataSourceID varchar(38)
) ; 

CREATE INDEX IX1_UserDataSource ON UserDataSource (DataSourceID,UserID) ;


CREATE TABLE Users (
  UserID varchar(50),
  Name varchar(50),
  LastLogonDate timestamp,
  Active char(1),
  AccessAllDataSources char(1),
  SecurityLevel char(1),
  PasswordChangeDate timestamp,
  Password varchar(255)
) ; 

CREATE INDEX IX1_Users ON Users (UserID) ;

INSERT INTO Users (UserID,Name,Active,AccessAllDataSources,SecurityLevel,Password)
VALUES ('admin','Administrator','Y','Y','A','') ;

